<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('uploaded_evaluations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('evaluation_value_id');
            $table->foreign('evaluation_value_id')->references('id')->on('evaluation_values')->onUpdate('cascade')->onDelete('cascade');
            $table->unsignedBigInteger('subscribe_id');
            $table->foreign('subscribe_id')->references('id')->on('student_subscribes')->onUpdate('cascade')->onDelete('cascade');
            $table->string('value');
            // 0 => ضعيف
            // 1 => جيد
            // 2 => جيد جدا
            // 3 => ممتاز
            $table->smallInteger('is_active')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('uploaded_evaluations');
    }
};
